<?PHP
  # Original PHP code by Chirp Internet: www.chirp.com.au
  # Please acknowledge use of this code by including this header.
  date_default_timezone_set("Asia/Hong_Kong");

  class myAtomParser
  {
    # keeps track of current and preceding elements
    var $tags = array();

    # array containing all feed data
    var $output = array();

    # return value for display functions
    var $retval = "";

    var $encoding = array();

    # constructor for new object
    function myAtomParser($file)
    {
      # instantiate xml-parser and assign event handlers
      $xml_parser = xml_parser_create("");
      xml_set_object($xml_parser, $this);
      xml_set_element_handler($xml_parser, "startElement", "endElement");
      xml_set_character_data_handler($xml_parser, "parseData");

      # open file for reading and send data to xml-parser
      $fp = @fopen($file, "r") or die("<b>myAtomParser Error:</b> Could not open URL $file for input");
      while($data = fread($fp, 4096)) {
        xml_parse($xml_parser, $data, feof($fp)) or die(
          sprintf("myAtomParser: Error <b>%s</b> at line <b>%d</b><br>",
          xml_error_string(xml_get_error_code($xml_parser)),
          xml_get_current_line_number($xml_parser))
        );
      }
      fclose($fp);

      # dismiss xml parser
      xml_parser_free($xml_parser);
    }

    function startElement($parser, $tagname, $attrs)
    {
      if($this->encoding) {
        # content is encoded - so keep elements intact
        $tmpdata = "<$tagname";
        if($attrs) foreach($attrs as $key => $val) $tmpdata .= " $key=\"$val\"";
        $tmpdata .= ">";
        $this->parseData($parser, $tmpdata);
      } else {
        if($attrs['HREF'] && $attrs['REL'] && $attrs['REL'] == 'alternate') {
          $this->startElement($parser, 'LINK', array());
          $this->parseData($parser, $attrs['HREF']);
          $this->endElement($parser, 'LINK');
        }
        if($attrs['TYPE']) $this->encoding[$tagname] = $attrs['TYPE'];

        # check if this element can contain others - list may be edited
        if(preg_match("/^(FEED|ENTRY)$/", $tagname)) {
          if($this->tags) {
            $depth = count($this->tags);
            list($parent, $num) = each($tmp = end($this->tags));
            if($parent) $this->tags[$depth-1][$parent][$tagname]++;
          }
          array_push($this->tags, array($tagname => array()));
        } else {
          # add tag to tags array
          array_push($this->tags, $tagname);
        }
      }
    }

    function endElement($parser, $tagname)
    {
      # remove tag from tags array
      if($this->encoding) {
        if(isset($this->encoding[$tagname])) {
          unset($this->encoding[$tagname]);
          array_pop($this->tags);
        } else {
          if(!preg_match("/(BR|IMG)/", $tagname)) $this->parseData($parser, "</$tagname>");
        }
      } else {
        array_pop($this->tags);
      }
    }

    function parseData($parser, $data)
    {
      # return if data contains no text
      if(!trim($data)) return;
      $evalcode = "\$this->output";
      foreach($this->tags as $tag) {
        if(is_array($tag)) {
          list($tagname, $indexes) = each($tag);
          $evalcode .= "[\"$tagname\"]";
          if(${$tagname}) $evalcode .= "[" . (${$tagname} - 1) . "]";
          if($indexes) extract($indexes);
        } else {
          if(preg_match("/^([A-Z]+):([A-Z]+)$/", $tag, $matches)) {
            $evalcode .= "[\"$matches[1]\"][\"$matches[2]\"]";
          } else {
            $evalcode .= "[\"$tag\"]";
          }
        }
      }

      if(isset($this->encoding['CONTENT']) && $this->encoding['CONTENT'] == "text/plain") {
        $data = "<pre>$data</pre>";
      }

      eval("$evalcode .= '" . addslashes($data) . "';");
    }




    /*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
    /*::                                                                         :*/
    /*::  this routine calculates the distance between two points (given the     :*/
    /*::  latitude/longitude of those points). it is being used to calculate     :*/
    /*::  the distance between two zip codes or postal codes using our           :*/
    /*::  zipcodeworld(tm) and postalcodeworld(tm) products.                     :*/
    /*::                                                                         :*/
    /*::  definitions:                                                           :*/
    /*::    south latitudes are negative, east longitudes are positive           :*/
    /*::                                                                         :*/
    /*::  passed to function:                                                    :*/
    /*::    lat1, lon1 = latitude and longitude of point 1 (in decimal degrees)  :*/
    /*::    lat2, lon2 = latitude and longitude of point 2 (in decimal degrees)  :*/
    /*::    unit = the unit you desire for results                               :*/
    /*::           where: 'm' is statute miles                                   :*/
    /*::                  'k' is kilometers (default)                            :*/
    /*::                  'n' is nautical miles                                  :*/
    /*::  united states zip code/ canadian postal code databases with latitude & :*/
    /*::  longitude are available at http://www.zipcodeworld.com                 :*/
    /*::                                                                         :*/
    /*::  For enquiries, please contact sales@zipcodeworld.com                   :*/
    /*::                                                                         :*/
    /*::  official web site: http://www.zipcodeworld.com                         :*/
    /*::                                                                         :*/
    /*::  hexa software development center  all rights reserved 2004            :*/
    /*::                                                                         :*/
    /*::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
    function distance($lat1, $lon1, $lat2, $lon2, $unit) { 

      $theta = $lon1 - $lon2; 
      $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta)); 
      $dist = acos($dist); 
      $dist = rad2deg($dist); 
      $miles = $dist * 60 * 1.1515;
      $unit = strtoupper($unit);

      if ($unit == "K") {
        return ($miles * 1.609344); 
      } else if ($unit == "N") {
          return ($miles * 0.8684);
        } else {
            return $miles;
          }
    }

    # display a single feed as HTML
    function display_feed($data, $limit)
    {
      extract($data);
     /*
	  if($TITLE) {
        # display feed information
        $this->retval .= "<h1>";
        if($LINK) $this->retval .= "<a href=\"$LINK\" target=\"_blank\">";
        $this->retval .= stripslashes($TITLE);
        if($LINK) $this->retval .= "</a>";
        $this->retval .= "</h1>\n";
        if($TAGLINE) $this->retval .= "<P>" . stripslashes($TAGLINE) . "</P>\n\n";
        $this->retval .= "<div class=\"divider\"><!-- --></div>\n\n";
      }
	  */
      if($ENTRY) {
        # display feed entry(s)
        foreach($ENTRY as $item) {
          if ($this->display_entry($item, "FEED")==1)
              break;
          if(is_int($limit) && --$limit <= 0) break;
        }
      }
    }

    # display a single entry as HTML
    function display_entry($data, $parent)
    {
        $earthquake_lat_str="";
        $earthquake_lon_str="";
        $earthquake_lat="";
        $earthquake_lon="";
        $earthquake_link="";
        $earthquake_imgpath="";
        $earthquake_place="";
        $earthquake_strength="";
        $earthquake_utctime="";
        $earthquake_hkttime="";
        $earthquake_localtime="";
        $earthquake_depth="";
        $earthquake_distanceToHK="";

          extract($data);
          if(!$TITLE) return;

          /*
          $this->retval .=  "<b>";
          if($LINK) $this->retval .=  "<a href=\"$LINK\" target=\"_blank\">";
          $this->retval .= stripslashes($TITLE);

          if($LINK) $this->retval .= "</a>";
          $this->retval .=  "</b>";
*/
        //$earthquake_link=$LINK;
		$earthquake_link=trim(substr(stripslashes($LINK), strpos(stripslashes($LINK), 'href="')));
		$earthquake_link=substr($earthquake_link, 0, strpos($earthquake_link, 'http://', 1));

        $earthquake_place=trim(substr(stripslashes($TITLE), strpos(stripslashes($TITLE), '-')+2));
        $earthquake_strength=trim(substr(stripslashes($TITLE), strpos(stripslashes($TITLE), '">M')+2, strpos(stripslashes($TITLE), '-')-strpos(stripslashes($TITLE), '">M')-2));


/*
	  if($ISSUED) $this->retval .= " <small>($ISSUED)</small>";
      $this->retval .=  "</p>\n";
*/

	/*
      if($AUTHOR) {
        $this->retval .=  "<P><b>Author:</b> " . stripslashes($AUTHOR['NAME']) . "</P>\n\n";
      }
	  */

/*	  if($CONTENT) {


        $this->retval .=  "\n\n" . stripslashes($CONTENT) . "\n\n";
      } elseif($SUMMARY) {
*/
		if($SUMMARY) {

			//$this->retval .=  "\n\n" . stripslashes($SUMMARY) . "\n\n<br><br>";

			//$earthquake_place=trim(substr(stripslashes($TITLE), strpos(stripslashes($TITLE), ',')+2));


			$earthquake_lat=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'Location</dt><dd>')+17, strpos(stripslashes($SUMMARY), '&deg;')-strpos(stripslashes($SUMMARY), 'Location</dt><dd>')-11));
			$earthquake_lon=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), '&deg;')+7, strpos(stripslashes($SUMMARY), '</dd><dt>Depth')-strpos(stripslashes($SUMMARY), '&deg;')-7));
			$earthquake_imgpath="";//trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'text/html" href="')+17, strpos(stripslashes($SUMMARY), '"/><link rel="alternate"')-strpos(stripslashes($SUMMARY), 'text/html" href="')-17));


			$earthquake_utctime=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), '</dt><dd>')+9, strpos(stripslashes($SUMMARY), 'UTC</dd>')-strpos(stripslashes($SUMMARY), '</dt><dd>')-9));

			$earthquake_hkttime=date('d/m/Y H:i:s', strtotime($earthquake_utctime)+ 3600*8);
			$earthquake_utctime=date('d/m/Y H:i:s', strtotime($earthquake_utctime));

			$earthquake_localtime=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'UTC</dd><dd>')+12, strpos(stripslashes($SUMMARY), 'at epicenter')-strpos(stripslashes($SUMMARY), 'UTC</dd><dd>')-12));

			$earthquake_timedifference = substr($earthquake_localtime,0, strlen($earthquake_localtime)-3);
			$earthquake_timedifference = substr($earthquake_timedifference,strlen($earthquake_timedifference)-3, strlen($earthquake_timedifference));	

			$earthquake_localtime=date('d/m/Y H:i:s', strtotime($earthquake_localtime)+3600*$earthquake_timedifference);

			$earthquake_depth=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'Depth</strong>:')+15, strpos(stripslashes($SUMMARY), 'km (')-strpos(stripslashes($SUMMARY), 'Depth</strong>:')-15));

            if(strstr($earthquake_lat, 'N') != false){
                $earthquake_lat=trim(substr($earthquake_lat, 0, 5));
                $earthquake_lat_str=$earthquake_lat."N";
            }else{
                $earthquake_lat=trim(substr($earthquake_lat, 0, 5));
                $earthquake_lat_str=$earthquake_lat."S";
                $earthquake_lat="-$earthquake_lat";
            }

            
            if(strstr($earthquake_lon, 'E') != false){
                $earthquake_lon=trim(substr($earthquake_lon, 0, 5));
                $earthquake_lon_str=$earthquake_lon."E";
            }else{
                $earthquake_lon=trim(substr($earthquake_lon, 0, 5));
                $earthquake_lon_str=$earthquake_lon."W";
                $earthquake_lon="-$earthquake_lon";
            }

            $earthquake_distanceToHK=$this->distance($earthquake_lat, $earthquake_lon, 22.3, 114.2, "k");

            if(($earthquake_distanceToHK<=600)||($earthquake_strength>=5.5)){

                    $this->retval .="<span class='subtitle'>Ia_ ($earthquake_hkttime HKT)</span><br>";
                    $this->retval .="<table border='0' bgColor='#FFFFFF' borderColor='#000000' cellspacing='0' cellpadding='0' width='320'><tr><td>";
					(($earthquake_strength>=7.0)||($earthquake_distanceToHK<=400))? $this->retval .="<span style='color:#FF0000'>":$this->retval .="<span>";
                    $this->retval .=" $earthquake_place ";
                    $this->retval .="($earthquake_lat_str ";
                    $this->retval .="$earthquake_lon_str) ";
                    $this->retval .="o$earthquake_strength Ŧa_C<a href=\"#\" onclick='parent.rbottom1.displayMap(\"$earthquake_lat_str\",\"$earthquake_lon_str\");return false;' style='cursor:hand;color:blue'>>>m</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"earthquake.php\" target=\"rbottom1\">>>a_</a>";
					$this->retval .="</span>";
                    $this->retval .="</td></tr></table></br></br>";

                    return 1;
            }
		}

        return 0;
    }




    function display_feed2($data, $limit)
    {
      extract($data);
     /*
	  if($TITLE) {
        # display feed information
        $this->retval .= "<h1>";
        if($LINK) $this->retval .= "<a href=\"$LINK\" target=\"_blank\">";
        $this->retval .= stripslashes($TITLE);
        if($LINK) $this->retval .= "</a>";
        $this->retval .= "</h1>\n";
        if($TAGLINE) $this->retval .= "<P>" . stripslashes($TAGLINE) . "</P>\n\n";
        $this->retval .= "<div class=\"divider\"><!-- --></div>\n\n";
      }
	  */

	  $counter=1;
      if($ENTRY) {
        # display feed entry(s)
        foreach($ENTRY as $item) {
          if($counter>0){ //ignore the 1st item
			  if ($this->display_entry2($item, "FEED")==1)
				  break;
			  if(is_int($limit) && --$limit <= 0) break;
		  }
		  $counter++;

        }
      }
    }



    # display a single entry as HTML
    function display_entry2($data, $parent)
    {
		//date_default_timezone_set("Hongkong");

        $earthquake_lat_str="";
        $earthquake_lon_str="";
        $earthquake_lat="";
        $earthquake_lon="";
        $earthquake_link="";
        $earthquake_imgpath="";
        $earthquake_place="";
        $earthquake_strength="";
        $earthquake_utctime="";
        $earthquake_hkttime="";
        $earthquake_localtime="";
        $earthquake_depth="";
        $earthquake_distanceToHK="";

          extract($data);
          if(!$TITLE) return;

        //$earthquake_link=$LINK;
		$earthquake_link=trim(substr(stripslashes($LINK), strpos(stripslashes($LINK), 'href="')));
		$earthquake_link=substr($earthquake_link, 0, strpos($earthquake_link, 'http://', 1));

        $earthquake_place=trim(substr(stripslashes($TITLE), strpos(stripslashes($TITLE), '-')+2));
        $earthquake_strength=trim(substr(stripslashes($TITLE), strpos(stripslashes($TITLE), '">M')+2, strpos(stripslashes($TITLE), '-')-strpos(stripslashes($TITLE), '">M')-2));

/*
	  if($ISSUED) $this->retval .= " <small>($ISSUED)</small>";
      $this->retval .=  "</p>\n";
*/

	/*
      if($AUTHOR) {
        $this->retval .=  "<P><b>Author:</b> " . stripslashes($AUTHOR['NAME']) . "</P>\n\n";
      }
	  */

/*	  if($CONTENT) {


        $this->retval .=  "\n\n" . stripslashes($CONTENT) . "\n\n";
      } elseif($SUMMARY) {
*/

		if($SUMMARY) {


//$earthquake_place=trim(substr(stripslashes($TITLE), strpos(stripslashes($TITLE), ',')+2));

			/*
			$earthquake_lat=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'alt="')+5, strpos(stripslashes($SUMMARY), '&#176;'+2)-strpos(stripslashes($SUMMARY), 'alt="')-5));
			$earthquake_lon=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), '&#176;')+7, strpos(stripslashes($SUMMARY), '" align')-strpos(stripslashes($SUMMARY), '&#176;')-7));
			$earthquake_imgpath=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'src="')+5, strpos(stripslashes($SUMMARY), '" alt="')-strpos(stripslashes($SUMMARY), 'src="')-5));
*/


			$earthquake_lat=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'Location</dt><dd>')+17, strpos(stripslashes($SUMMARY), '&deg;')-strpos(stripslashes($SUMMARY), 'Location</dt><dd>')-11));
			$earthquake_lon=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), '&deg;')+7, strpos(stripslashes($SUMMARY), '</dd><dt>Depth')-strpos(stripslashes($SUMMARY), '&deg;')-7));
			$earthquake_imgpath="";//trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'text/html" href="')+17, strpos(stripslashes($SUMMARY), '"/><link rel="alternate"')-strpos(stripslashes($SUMMARY), 'text/html" href="')-17));


			$earthquake_utctime=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), '</dt><dd>')+9, strpos(stripslashes($SUMMARY), 'UTC</dd>')-strpos(stripslashes($SUMMARY), '</dt><dd>')-9));

			$earthquake_localtime=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'UTC</dd><dd>')+12, strpos(stripslashes($SUMMARY), 'at epicenter')-strpos(stripslashes($SUMMARY), 'UTC</dd><dd>')-12));

			$earthquake_hkttime=date('d/m/Y H:i:s', strtotime($earthquake_utctime)+ 3600*8);
			$earthquake_utctime=date('d/m/Y H:i:s', strtotime($earthquake_utctime));

			$earthquake_timedifference = substr($earthquake_localtime,0, strlen($earthquake_localtime)-3);
			$earthquake_timedifference = substr($earthquake_timedifference,strlen($earthquake_timedifference)-3, strlen($earthquake_timedifference));	

			$earthquake_localtime=date('d/m/Y H:i:s', strtotime($earthquake_localtime)+3600*$earthquake_timedifference);

			$earthquake_depth=trim(substr(stripslashes($SUMMARY), strpos(stripslashes($SUMMARY), 'Depth</dt><dd>')+14, strpos(stripslashes($SUMMARY), 'km')-strpos(stripslashes($SUMMARY), 'Depth</dt><dd>')-14));

            if(strstr($earthquake_lat, 'N') != false){
                $earthquake_lat=trim(substr($earthquake_lat, 0, 5));
                $earthquake_lat_str=$earthquake_lat."N";
            }else{
                $earthquake_lat=trim(substr($earthquake_lat, 0, 5));
                $earthquake_lat_str=$earthquake_lat."S";
                $earthquake_lat="-$earthquake_lat";
            }

            
            if(strstr($earthquake_lon, 'E') != false){
                $earthquake_lon=trim(substr($earthquake_lon, 0, 5));
                $earthquake_lon_str=$earthquake_lon."E";
            }else{
                $earthquake_lon=trim(substr($earthquake_lon, 0, 5));
                $earthquake_lon_str=$earthquake_lon."W";
                $earthquake_lon="-$earthquake_lon";
            }

            $earthquake_distanceToHK=$this->distance($earthquake_lat, $earthquake_lon, 22.3, 114.2, "k");

/*
            <b><a href="http://earthquake.usgs.gov/earthquakes/recenteqsww/Quakes/usb0001k0y.php" target="_blank">M 3.2, Arkansas</a></b>

<img src="http://earthquake.usgs.gov/images/globes/35_-90.jpg" alt="35.261&#176;N 92.374&#176;W" align="left" hspace="20" /><p>Thursday, February 24, 2011 15:07:10 UTC<br>Thursday, February 24, 2011 09:07:10 AM at epicenter</p><p><strong>Depth</strong>: 1.20 km (0.75 mi)</p>
*/

              $this->retval .=  "<span class=\"msg_head\" style=\"font-size:14px\">";
              $this->retval .=  " <a href=\"#\" onclick=\"return false;\" style=\"font-weight: bold";
              if(($earthquake_distanceToHK<=600)||($earthquake_strength>=7.0)){
                    $this->retval .=" ;color:#FF0000";
              }else if ($earthquake_strength>=5.5){
                    $this->retval .=" ;color:#EE7700";
			  }
              $this->retval .="  \">";
              $this->retval .= " $earthquake_place o$earthquake_strength Ŧa_]$earthquake_hkttime HKT^";
              $this->retval .= "</a>";
              $this->retval .=  "</span>";

              $this->retval .=  "<div class=\"msg_body\"><table border=0 width='800'><tr><td width=\"150\">\n\n" ;
              if($LINK) $this->retval .="<a href=\"#\" onclick=\"displayMap('$earthquake_lat_str','$earthquake_lon_str');return false;\">";
              //$this->retval .=  "<img src=\"$earthquake_imgpath \" border=\"0\">";
			  $this->retval .=  "a";
              if($LINK) $this->retval .="</a>";
              $this->retval .="</td><td align=\"left\" valign=\"top\">";
              $this->retval .="ɶG$earthquake_hkttime<br/>";
              $this->retval .="aɶG$earthquake_localtime<br/>";
              $this->retval .="ծɶG$earthquake_utctime<br/>";
              $this->retval .="_mG$earthquake_place ($earthquake_lat_str ,$earthquake_lon_str)<br/>";
              $this->retval .="JSG$earthquake_strength <br/>";
              $this->retval .="_`סG$earthquake_depth km<br/>";
              $this->retval .="ZG".round($earthquake_distanceToHK,2)."km<br/>";
              if($LINK) $this->retval .="<a href=\"$earthquake_link \" target=\"_blank\">";
              if($LINK) $this->retval .="<br/>ԲӸ<br/>";
              if($LINK) $this->retval .="</a>";
              $this->retval .="\n\n</td></tr></table></div> <br/><br/>";
		}


    }


    function fixEncoding($input, $output_encoding)
    {
      if(!function_exists('mb_detect_encoding')) return $input;

      $encoding = mb_detect_encoding($input);
      switch($encoding) {
        case 'ASCII':
        case $output_encoding:
          return $input;
        case '':
          return mb_convert_encoding($input, $output_encoding);
        default:
          return mb_convert_encoding($input, $output_encoding, $encoding);
      }
    }

    # display entire feed as HTML
    function getOutput($limit=false, $output_encoding='')
    {
      $this->retval = "";
      $start_tag = key($this->output);

      switch($start_tag) {
        case "FEED":
          foreach($this->output as $feed) $this->display_feed($feed, $limit);
          break;
        default:
          die("Error: unrecognized start tag '$start_tag' in getOutput()");
      }

      return $this->fixEncoding($this->retval, $output_encoding);
    }


    # display entire feed as HTML
    function getOutput2($limit=false, $output_encoding='')
    {
      $this->retval = "";
      $start_tag = key($this->output);

      switch($start_tag) {
        case "FEED":
          foreach($this->output as $feed) $this->display_feed2($feed, $limit);
          break;
        default:
          die("Error: unrecognized start tag '$start_tag' in getOutput()");
      }

      return $this->fixEncoding($this->retval, $output_encoding);
    }





    # return raw data as array
    function getRawOutput($output_encoding='UTF-8')
    {
      return $this->fixEncoding($this->output, $output_encoding);
    }
  }
?>
